<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
   {* Document/Browser title *}
   <title>{if empty ($TITLE)}{$smarty.const.DIRECTORY_TITLE|escape|trim}{/if}{$smarty.capture.title|strip|trim}</title>

   {* Document character set *}
   <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

   {* CSS Style file *}
   <link rel="stylesheet" type="text/css" href="{$smarty.const.DOC_ROOT}/templates/{$smarty.const.USE_TEMPLATE}/style/main.css" />

   {* Custom META tags *}
   {if $smarty.const.ENABLE_META_TAGS}
      {if !empty($MetaKeywords)}
         <meta name="keywords" content="{$MetaKeywords|strip|escape|trim}" />
      {/if}
      {if !empty($MetaDescription)}
         <meta name="description" content="{$MetaDescription|strip|escape|trim}" />
      {/if}
      {if !empty($MetaAuthor)}
         <meta name="author" content="{$MetaAuthor|strip|escape|trim}" />
      {/if}
      {if !empty($MetaCopyright)}
         <meta name="copyright" content="{$MetaCopyright|strip|escape|trim}" />
      {/if}
      {if !empty($MetaRobots)}
         <meta name="robots" content="{$MetaRobots|strip|escape|trim}" />
      {/if}
   {/if}

   {* Please keep this line for better version tracking *}
   <meta name="generator" content="PHP Link Directory {$smarty.const.CURRENT_VERSION}" />

   {* Live Bookmarks *}
   {if $smarty.const.ENABLE_RSS and (!empty($search) or $category.ID gt 0 or $list) and count($links) gt 0}
      <link rel="alternate" type="application/rss+xml" title="{$in_page_title|escape|trim}" href="{$smarty.const.SITE_URL}rss.php?{if !empty($search)}search={$search|@urlencode}{elseif $p}p={$p}{elseif $list}list={$list}{else}c={$category.ID}{/if}" />
   {/if}

   {* JavaScript libraries *}
   {if $load_Javascript}
      {* SmartyFormtool for manipulating forms with JavaScript *}
      <script type="text/javascript" src="{$smarty.const.DOC_ROOT}/javascripts/formtool/formtool.js"></script>
      {* Prototype library - all comming JavaScripts are based on this *}
      <script type="text/javascript" src="{$smarty.const.DOC_ROOT}/javascripts/prototype/prototype.js"></script>
      {* Scriptaculous - Incredible effects and controls library built on Prototype *}
      <script type="text/javascript" src="{$smarty.const.DOC_ROOT}/javascripts/scriptaculous/scriptaculous.js"></script>
      {* AJAX category selection library *}
      <script type="text/javascript" src="{$smarty.const.DOC_ROOT}/javascripts/categ_selection/categ_selection.js"></script>
   {/if}
</head>
<body>

{* Error and confirmation messages *}
{include file="../$core_templates/messages.tpl"}
<div id="wrapper">

<div id="header">
	<a id="logo" href="{$smarty.const.DOC_ROOT}/index.php"></a>

	<div class="searchbox">
		{* Search form *}
		<form action="{$smarty.const.DOC_ROOT}/index.php" method="get">
			<input type="text" name="search" size="24" maxlength="250" class="searchtext" value="{if !empty($search)}{$search|escape}{/if}" /> <input type="submit" value="" class="btn-search" />
		</form>    
	</div>  
</div>

<div id="nav">
	<a class="btn-nav2" href="{$smarty.const.DOC_ROOT}/index.php">{l}Home{/l}</a>
	<a class="btn-nav" href="{$smarty.const.DOC_ROOT}/submit.php{if !empty ($category.ID) and $category.ID > 0}?c={$category.ID}{/if}" title="{l}Submit your link to the directory{/l}">{l}Add URL{/l}</a>
	<a class="btn-nav" href="{$smarty.const.DOC_ROOT}/index.php?list=latest" title="{l}Browse latest submitted links{/l}">{l}Latest Links{/l}</a>
	<a class="btn-nav" href="{$smarty.const.DOC_ROOT}/index.php?list=top" title="{l}Browse most popular links{/l}">{l}Top Hits{/l}</a>
</div>


