<?php 

#########################################################################################################
# Project:		PHPLinkDirectory: Link exchange directory @ http://www.phplinkdirectory.com/			#
# Mod:			[Contact Us] @ http://www.monster-submit.com/phpld/										#
# Version:		3.00																					#
# Notice:		Maintain this section																	#
# Author:		Virtual Solutions																		#
# License:		Copyright (c) 2006 - 2007 Virtual Solutions												#
#																										#
# Any redistribution of phpLD_Vault mods without the expressed written consent of Virtual Solutions is	#
# strictly prohibited. Copying any of the code contained within any phpLD_Vault mod and claiming it as	#
# your own is also prohibited. You may not remove any header notices from any mods. By using these		#
# phpLD_Vault mods, you agree to indemnify Virtual Solutions from any liability that might arise from	#
# their use.																							#
#																										#
# PHPLD_VAULT MODS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING	#
# BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND			#
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES	#
# OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN	#
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							#
#########################################################################################################

##########################################################################
#  Do NOT change or alter the code below!
##########################################################################

require_once 'init.php';
require_once 'lang/vsmod/contact_lang.php';

session_start();
require_once 'include/version.php';
$admin		= array();
$admin		= $db->GetRow("SELECT * FROM `{$tables['user']['name']}` WHERE `ID` = '1' AND `ADMIN` = '1'");
if (! $admin) {
	$admin		= $db->GetRow("SELECT * FROM `{$tables['user']['name']}` WHERE `ID` = '1' AND `LEVEL` = '1'");
}
$email		= $admin['EMAIL'];
$name		= $admin['NAME'];
unset($admin);
$version = CURRENT_VERSION;
$version = preg_replace('/\.(\d+) RC(.*)$/', '', $version);
if (! $email) { error("No [Webmaster Email Address] defined"); }
if (! $name) { $name = "Admin"; }
if (! $version) { error("No [phpLD Version] defined"); }
$tpl->assign('version', $version);
$tpl->assign('language', $language);

if ($version >= 3.10) {
	if (VISUAL_CONFIRM == 1) {
		require_once 'include/functions_imgverif.php';
		$imagehash = fetch_captcha_hash();
		$tpl->assign('imagehash', $imagehash);
		unset($imagehash);
	}
}

function check_captcha($value, $empty, & $params, & $form) {
	require_once 'libs/captcha/captcha.class.php';
	return isset($_SESSION['CAPTCHA']) && strtolower($_SESSION['CAPTCHA']) == strtolower($value);
}

function clean_input($input){
$input	= htmlspecialchars(trim($input));
if (get_magic_quotes_gpc()) { $input = stripslashes($input); }
return $input;
}

function check_input($input) {
if (eregi("%0a", $input) || eregi("%0d", $input) || eregi("Content-Type:", $input) || eregi("bcc:", $input) || eregi("to:", $input) || eregi("cc:", $input)) {
	return 0;
}
else { return 1; }
}

function error($err) {
	global $tpl, $data, $language;
	$path	= array();
	$path[]	= array('ID' => '0', 'TITLE' => _L(SITE_NAME), 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC); 
	$path[]	= array('ID' => '0', 'TITLE' => _L($language['L_TITLE']), 'TITLE_URL' => '', 'DESCRIPTION' => _L($language['L_DESCRIPTION']));
	$tpl->assign($data);
	$tpl->assign($language);
	$tpl->assign('ERROR', $err);
	$tpl->assign('path', $path);
	echo $tpl->fetch('contact.tpl');
	unset($language);
	unset($data);
	unset($path);
	unset($_POST, $_GET, $_REQUEST);
	exit;
}

if (empty($_POST['submit'])) {
	if (! empty($_SERVER['HTTP_REFERER'])) { $_SESSION['return'] = $_SERVER['HTTP_REFERER']; }
	SmartyValidate :: connect($tpl);
	SmartyValidate :: register_form('contact_us', true);
	SmartyValidate :: register_criteria('isNotEqual', 'validate_not_equal', 'contact_us');
	if ($version > 2) {
		SmartyValidate :: register_validator('v_NAME', 'NAME', 'notEmpty', false, false, trim, 'contact_us');
		SmartyValidate :: register_validator('v_EMAIL', 'EMAIL', 'isEmail', false, false, trim, 'contact_us');
		SmartyValidate :: register_validator('v_REASON', 'REASON:0', 'isNotEqual', true, false, false, 'contact_us');
		SmartyValidate :: register_validator('v_MESSAGE', 'MESSAGE', 'notEmpty', false, false, trim, 'contact_us');
	}
	else {
		SmartyValidate :: register_validator('v_NAME', 'NAME', 'notEmpty', false, false, false, 'trim', 'contact_us');
		SmartyValidate :: register_validator('v_EMAIL', 'EMAIL', 'isEmail', false, false, false, 'trim', 'contact_us');
		SmartyValidate :: register_validator('v_REASON', 'REASON:0', 'isNotEqual', true, false, false, 'trim', 'contact_us');
		SmartyValidate :: register_validator('v_MESSAGE', 'MESSAGE', 'notEmpty', false, false, false, 'trim', 'contact_us');	
	}
	if (VISUAL_CONFIRM == 1) {
		if ($version >= 3.10) {
			SmartyValidate :: register_criteria('isCaptchaValid', 'validate_captcha', 'contact_us');
			SmartyValidate :: register_validator('v_CAPTCHA', 'CAPTCHA:IMAGEHASH', 'isCaptchaValid', false, false, null, 'contact_us');
		}
		elseif (($version > 2) && ($version < 3.10)) {
			SmartyValidate :: register_criteria('isCaptchaValid', 'validate_captcha', 'contact_us');
			SmartyValidate :: register_validator('v_CAPTCHA', 'CAPTCHA', 'isCaptchaValid', false, false, null, 'contact_us');
		}
		else {
			SmartyValidate :: register_criteria('isCaptchaValid', 'check_captcha', 'contact_us');
			SmartyValidate :: register_validator('v_CAPTCHA', 'CAPTCHA', 'isCaptchaValid', false, false, false, null, 'contact_us');
		}
	}
}
else {
	SmartyValidate :: connect($tpl);
	$data				= array();
	$data['NAME']		= clean_input($_POST['NAME']);
	if (! check_input($data['NAME'])) { error($language['L_INVALID_NAME']); }
	$data['EMAIL']		= clean_input($_POST['EMAIL']);
	if (! check_input($data['EMAIL'])) { error('INVALID_EMAIL'); }
	$data['REASON']		= clean_input($_POST['REASON']);
	if (! check_input($data['REASON'])) { error('INVALID_REASON'); }
	$data['MESSAGE']	= clean_input($_POST['MESSAGE']);
	if (! check_input($data['MESSAGE'])) { error('INVALID_MESSAGE'); }
	
	if (VISUAL_CONFIRM == 1) {
		if ($version >= 3.10) {
			if (! empty ($_POST['CAPTCHA'])) {
				$data = array_merge($data, array('CAPTCHA' => $_POST['CAPTCHA'], 'IMAGEHASH' => $_POST['IMAGEHASH']));
			}
		}
		else { $data = array_merge($data, array('CAPTCHA' => $_REQUEST['CAPTCHA'])); }
	}

	$pattern	= array();
	$replace	= array();
	foreach($language as $key1=>$val1) {
		if (! is_array($val1)) {
			$pattern[0]			= '/{NAME}/i';
			$pattern[1]			= '/{EMAIL}/i';
			$pattern[2]			= '/{REASON}/i';
			$pattern[3]			= '/{MESSAGE}/i';
			$pattern[4]			= '/{IP}/i';
			$pattern[5]			= '/{SITE_NAME}/i';
			$pattern[6]			= '/{SITE_URL}/i';
			$replace[0]			= $data['NAME'];
			$replace[1]			= $data['EMAIL'];
			$replace[2]			= $data['REASON'];
			$replace[3]			= $data['MESSAGE'];
			$replace[4]			= get_client_ip();
			$replace[5]			= SITE_NAME;
			$replace[6]			= SITE_URL;
			$val1				= preg_replace($pattern, $replace, $val1);
			$language[$key1]	= $val1;
		}
		else {
			foreach($val1 as $key2=>$val2) {
				$pattern[0]			= '/{NAME}/i';
				$pattern[1]			= '/{EMAIL}/i';
				$pattern[2]			= '/{REASON}/i';
				$pattern[3]			= '/{MESSAGE}/i';
				$pattern[4]			= '/{IP}/i';
				$replace[0]			= $data['NAME'];
				$replace[1]			= $data['EMAIL'];
				$replace[2]			= $data['REASON'];
				$replace[3]			= $data['MESSAGE'];
				$replace[4]			= get_client_ip();
				$val2				= preg_replace($pattern, $replace, $val2);
				$language[$key1]	= $val2;
			}
			unset($val1);
		}
	}
	if (SmartyValidate :: is_valid($data, 'contact_us')) {
		require_once 'libs/phpmailer/class.phpmailer.php';
		$mail				= new PHPMailer();
		$mail->PluginDir	= 'libs/phpmailer/';
		$mail->Mailer		= 'mail';
		$mail->From			= $data['EMAIL'];
		$mail->FromName		= $data['NAME'];
		$mail->Subject		= $language['L_EMAIL_SUBJECT'];
		$mail->Body			= $language['L_EMAIL_BODY'];
		$mail->AddAddress($email, $name);
		if (! $mail->Send()) { $tpl->assign('error', true); }
		else { $tpl->assign('success', true); }
		$mail->ClearAddresses();
		if (isset ($data['CAPTCHA'])) { unset($data['CAPTCHA']); }
		if (isset ($data['IMAGEHASH'])) { unset($data['IMAGEHASH']); }
		unset($_POST, $_GET, $_REQUEST);
	}
}

if (VISUAL_CONFIRM == 1) { $tpl->assign('captcha_length', CAPTCHA_PHRASE_LENGTH); }

$path	= array();
$path[]	= array('ID' => '0', 'TITLE' => _L(SITE_NAME), 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC); 
$path[] = array('ID' => '0', 'TITLE' => _L($language['L_TITLE']), 'TITLE_URL' => '', 'DESCRIPTION' => _L($language['L_DESCRIPTION']));
$tpl->assign($data);
$tpl->assign($language);
$tpl->assign('path', $path);
echo $tpl->fetch('contact.tpl');
unset($language);
unset($data);
unset($path);

?>
