<?php
/**
# ################################################################################
# Project:   PHP Link Directory
#
# **********************************************************************
# Copyright (C) 2004-2006 NetCreated, Inc. (http://www.netcreated.com/)
#
# This software is for use only to those who have purchased a license.
# A license must be purchased for EACH installation of the software.
#
# By using the software you agree to the terms:
#
#    - You may not redistribute, sell or otherwise share this software
#      in whole or in part without the consent of the the ownership
#      of PHP Link Directory. Please contact david@david-duval.com
#      if you need more information.
#
#    - You agree to retain a link back to http://www.phplinkdirectory.com/
#      on all pages of your directory in you purchased the $25 version
#      of the software.
#
# License holders are entitled to upgrades to the 3.0 branch of the software
# as they are made available at ttp://www.phplinkdirectory.com/
#
# In some cases, license holders may be required to agree to changes
# in the software license before receiving updates to the software.
# **********************************************************************
#
# For questions, help, comments, discussion, etc., please join the
# PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
#
# @link           http://www.phplinkdirectory.com/
# @copyright      2004-2006 NetCreated, Inc. (http://www.netcreated.com/)
# @projectManager David DuVal <david@david-duval.com>
# @package        PHPLinkDirectory
# @version        3.2.0
# ################################################################################
*/

/**
 * Define some application wide constants to increase security.
 * By checking them in included files, further execution can be blocked for unauthorized access.
 */
define ('IN_PHPLD', true); //For all files

//Set the current unix timestamp
define ('TIMENOW', time ());

//Detect web-server software
define ('IS_APACHE', ( strstr ($_SERVER['SERVER_SOFTWARE'], 'Apache') || strstr ($_SERVER['SERVER_SOFTWARE'], 'LiteSpeed') ) ? 1 : 0);
define ('IS_IIS'   , strstr ($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') ? 1 : 0);

require_once 'include/version.php';
require_once 'include/config.php';
require_once 'include/client_info.php';
require_once 'include/settings.php';
require_once 'include/tables.php';
require_once 'include/functions.php';
require_once 'include/functions_validate.php';
require_once 'include/dirdb.php';

session_start();

define ('DOC_ROOT', substr ($_SERVER["SCRIPT_NAME"], 0, strrpos ($_SERVER["SCRIPT_NAME"], '/')));

if (!defined ('DB_DRIVER'))
{
   http_redirect(DOC_ROOT.'/install/index.php');
}

require_once 'libs/intsmarty/intsmarty.class.php';
require_once 'libs/smarty/SmartyPaginate.class.php';
require_once 'libs/smarty/SmartyValidate.class.php';
require_once 'libs/adodb/adodb.inc.php';

if (get_magic_quotes_gpc())
{
   function stripslashes_deep($value)
   {
       $value = is_array ($value) ? array_map ('stripslashes_deep', $value) : stripslashes ($value);
       return $value;
   }

   $_POST    = array_map ('stripslashes_deep', $_POST);
   $_REQUEST = array_map ('stripslashes_deep', $_REQUEST);
   $_COOKIE  = array_map ('stripslashes_deep', $_COOKIE);
}

//Connect to database
$db = ADONewConnection(DB_DRIVER);
if ($db->Connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME))
{
   $db->SetFetchMode(ADODB_FETCH_ASSOC);
   $phpldSettings = read_config($db);
}
else
{
   define('ERROR', 'ERROR_DB_CONNECT');
}

if (DEBUG === 1)
{
   set_log('frontend_log.txt');
}

//Load input filter
require_once 'libs/inputfilter/class.inputfilter_php4.php';

//Run input filter, request variables should be safe now
require_once 'include/io_filter.php';

//Initialize template
$tpl = get_tpl();
$tpl->cache_lifetime = 0;

define ('TEMPLATE_PATH'     , 'templates/'.USE_TEMPLATE);
define ('FULL_TEMPLATE_PATH', DOC_ROOT.'/templates/'.USE_TEMPLATE);

$tpl->assign('core_templates', CORE_TEMPLATES);

require_once 'include/constants.php';

$tpl->assign('VERSION', CURRENT_VERSION);

//META Tags
$MetaKeywords    = DEFAULT_META_KEYWORDS;
$MetaDescription = DEFAULT_META_DESCRIPTION;
$MetaAuthor      = DEFAULT_META_AUTHOR;
$MetaCopyright   = DEFAULT_META_COPYRIGHT;
$MetaRobots      = DEFAULT_META_ROBOTS;

$tpl->assign('MetaRobots'     , trim ($MetaRobots)      );
$tpl->assign('MetaKeywords'   , trim ($MetaKeywords)    );
$tpl->assign('MetaDescription', trim ($MetaDescription) );
$tpl->assign('MetaAuthor'     , trim ($MetaAuthor)      );
$tpl->assign('MetaCopyright'  , trim ($MetaCopyright)   );

//By default, Javascript libraries are disabled
//If needed enable them on submit page or whatever else page
$load_Javascript = 0;
$tpl->assign('load_Javascript', $load_Javascript);

$regular_user_details = $db->GetRow("SELECT `ID`, `LOGIN`, `NAME`, `EMAIL` FROM `{$tables['user']['name']}` WHERE `ID` = ".$db->qstr($_SESSION['phpld']['user']['id'])." AND `ACTIVE` = '1'");
$tpl->assign('regular_user_details', $regular_user_details);

// Disallow access to the page if it's not allowed for editors
if ($_SESSION['phpld']['user']['id'])
{
   if (preg_match ('!^admin/?([a-bA-B](\.php))?$!', $_SESSION['return']))
      $_SESSION['return'] = SITE_URL;
}

$URLcomponents = @ parse_url ($_SERVER['REQUEST_URI']);
if (is_array ($URLcomponents) && !empty ($URLcomponents))
{
   @ parse_str ($URLcomponents['query'], $URLvariables);
}
// LinkStats
require_once 'statistic.php';

//random featured
$random_link = $db->GetAll("SELECT * FROM {$tables['link']['name']} WHERE FEATURED = 1 AND STATUS=2 ORDER BY RAND() LIMIT 1");
$tpl->assign('random_link', $random_link);
?>