{capture name="title"} - {l}Submit Link{/l}{/capture}
{capture assign="in_page_title"}{l}Submit Link{/l}{/capture}
{capture assign="description"}{l}Submit a new link to the directory{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}

{strip}
{if $smarty.const.REQUIRE_REGISTERED_USER == 1 and empty($regular_user_details.ID)}

<table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
   <tr>
      <td>
         <h3>{l}Information{/l}</h3>
      </td>
   </tr>
   <tr>
      <td>
         {l}You must be logged in to submit a new link.{/l}
         <br />
         {l}No account yet?{/l} <a href="{$smarty.const.DOC_ROOT}/profile.php?mode=register" title="{l}Register new user{/l}">{l}Create one{/l}</a>
      </td>
   </tr>
</table>

{else}
<h3>Submit Link</h3>
<form method="post" action="">
<table border="0" cellspacing="0" cellpadding="0" width="100%" id="formPage">
{if $error}
   <tr><td colspan="2" class="err">
      {l}An error occured while saving the link.{/l}
   </td></tr>
{/if}

{if $double_review and !$posted}
<tr><td colspan="2" class="err">
   {$double_review}
</td></tr>
{/if}

{if $posted}
   <tr><td colspan="2" class="msg">
   {l}Link submitted and awaiting approval.{/l}<br />
   {l}Submit another link.{/l}
   </td></tr>
{/if}

{if count($price) gt 0}
   <tr><td colspan="2" class="price">
   <b>{l}Pricing{/l}:</b><br />
   <table border="0" cellspacing="0" cellpadding="0">
   {if $price.featured}
      <tr><td><input type="radio" name="LINK_TYPE" value="featured" {if $LINK_TYPE eq 'featured'}checked="true"{/if}>{l}Featured links{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.featured}</td></tr>
   {/if}
   {if $price.normal gt 0}
      <tr><td><input type="radio" name="LINK_TYPE" value="normal" {if $LINK_TYPE eq 'normal'}checked="true"{/if}>{l}Regular links{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.normal}</td></tr>
   {elseif $price.normal eq 0}
      <tr><td><input type="radio" name="LINK_TYPE" value="normal" {if $LINK_TYPE eq 'normal'}checked="true"{/if}>{l}Regular links{/l}</td><td>{l}free{/l}</td></tr>
   {/if}
   {if $price.reciprocal gt 0}
      <tr><td><input type="radio" name="LINK_TYPE" value="reciprocal" {if $LINK_TYPE eq 'reciprocal'}checked="true"{/if}>{l}Regular links with reciprocal{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.reciprocal}</td></tr>
   {elseif $price.reciprocal eq 0}
      <tr><td><input type="radio" name="LINK_TYPE" value="reciprocal" {if $LINK_TYPE eq 'reciprocal'}checked="true"{/if}>{l}Regular links with reciprocal{/l}</td><td>{l}free{/l}</td></tr>
   {/if}
   {if isset($price.free)}
      <tr><td><input type="radio" name="LINK_TYPE" value="free" {if $LINK_TYPE eq 'free'}checked="true"{/if}>{l}Links with nofollow attribute{/l}</td><td>free</td></tr>
   {/if}
   </table>
   {validate form="submit_link" id="v_LINK_TYPE" message=$smarty.capture.field_link_type}
   {if isset($AllowedFeat) and $AllowedFeat ne 1}
      <br /><span class="errForm">{l}No more featured links allowed for this category.{/l}</span>
   {/if}
   </td></tr>
{/if}
  <tr>
   <td class="label"><span class='req'>*</span>{l}Title{/l}:</td>
   <td class="field">
      <input type="text" name="TITLE" value="{$TITLE|escape|trim}" size="40" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" />
      {validate form="submit_link" id="v_TITLE" message=$smarty.capture.field_char_required}
      {if $review_link == 0 || $remove_link == 0}
         {validate form="submit_link" id="v_TITLE_U" message=$smarty.capture.title_not_unique}
      {/if}
      {validate form="submit_link" id="v_TITLE_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.TITLE_MIN_LENGTH|replace:'#MAX#':$smarty.const.TITLE_MAX_LENGTH}
   </td>
  </tr>
  <tr>
   <td class="label"><span class='req'>*</span>{l}URL{/l}:</td>
   <td class="field">
      <input type="text" name="URL" value="{$URL|escape|trim}" size="40" maxlength="255" class="text"/>
      {validate form="submit_link" id="v_URL" message=$smarty.capture.invalid_url}
      {validate form="submit_link" id="v_URL_ONLINE" message=$smarty.capture.url_not_online}
      {if $smarty.const.ALLOW_MULTIPLE eq 1}
         {validate form="submit_link" id="v_URL_U" message=$smarty.capture.domain_not_unique_categ}
      {else}
         {validate form="submit_link" id="v_URL_U" message=$smarty.capture.domain_not_unique}
      {/if}

      {if !$secondBanCheck}
         {validate form="submit_link" id="v_URL_BANNED" message=$smarty.capture.domain_banned}
      {else}
         {$smarty.capture.domain_banned}
      {/if}
   </td>
  </tr>
  <tr>
   <td class="label">{l}Description{/l}:</td>
   <td class="field">
      <textarea name="DESCRIPTION" rows="3" cols="37" class="text" {formtool_count_chars name="DESCRIPTION" limit=$smarty.const.DESCRIPTION_MAX_LENGTH alert=true}>{$DESCRIPTION|escape|trim}</textarea>
      {validate form="submit_link" id="v_DESCRIPTION_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.DESCRIPTION_MIN_LENGTH|replace:'#MAX#':$smarty.const.DESCRIPTION_MAX_LENGTH}
      <br />
      {l}Limit{/l}: <input type="text" name="DESCRIPTION_limit" size="4" class="limit_field" readonly="readonly" value="{$DescriptionLimit|trim}" />
   </td>
  </tr>

   {if $smarty.const.ENABLE_META_TAGS eq 1 and $smarty.const.ENABLE_USER_META_TAGS eq 1}
   <tr>
      <td class="label">{l}META Keywords{/l}:</td>
      <td class="field">
        <input type="text" name="META_KEYWORDS" value="{$META_KEYWORDS|escape|trim}" size="40" maxlength="2000" class="text" />
        <p class="small">{l}Separate keywords by comma.{/l}</p>
        {validate form="submit_link" id="v_META_KEYWORDS_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.META_KEYWORDS_MIN_LENGTH|replace:'#MAX#':$smarty.const.META_KEYWORDS_MAX_LENGTH}
      </td>
   </tr>
   <tr>
      <td class="label">{l}META Description{/l}:</td>
      <td class="field">
         <textarea name="META_DESCRIPTION" rows="3" cols="30" class="text" {formtool_count_chars name="META_DESCRIPTION" limit=$smarty.const.META_DESCRIPTION_MAX_LENGTH alert=true}>{$META_DESCRIPTION|escape|trim}</textarea>
         {validate form="submit_link" id="v_META_DESCRIPTION_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.META_DESCRIPTION_MIN_LENGTH|replace:'#MAX#':$smarty.const.META_DESCRIPTION_MAX_LENGTH}
         <br />
         {l}Limit{/l}: <input type="text" name="META_DESCRIPTION_limit" size="4" class="limit_field" readonly="readonly" value="{$MetaDescriptionLimit|trim}" />
      </td>
   </tr>
   {/if}

   {if $smarty.const.REQUIRE_REGISTERED_USER == 0 || empty($regular_user_details.ID)}
   <tr>
      <td class="label"><span class='req'>*</span>{l}Your Name{/l}:</td>
      <td class="field">
         <input type="text" name="OWNER_NAME" value="{$OWNER_NAME|escape|trim}" size="40" maxlength="{$smarty.const.USER_NAME_MAX_LENGTH}" class="text" />
         {validate form="submit_link" id="v_OWNER_NAME" message=$smarty.capture.field_char_required}
         {validate form="submit_link" id="v_OWNER_NAME_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.USER_NAME_MIN_LENGTH|replace:'#MAX#':$smarty.const.USER_NAME_MAX_LENGTH}
      </td>
   </tr>
   <tr>
      <td class="label"><span class='req'>*</span>{l}Your Email{/l}:</td>
      <td class="field">
         <input type="text" name="OWNER_EMAIL" value="{$OWNER_EMAIL|escape|trim}" size="40" maxlength="255" class="text" />
         {validate form="submit_link" id="v_OWNER_EMAIL" message=$smarty.capture.invalid_email}
         {validate form="submit_link" id="v_OWNER_EMAIL_BANNED" message=$smarty.capture.email_banned}
      </td>
   </tr>
   {/if}

   <tr>
   <td class="label"><span class='req'>*</span>{l}Category{/l}:</td>
   <td class="field">
      {* Load category selection *}
      {include file="category_select.tpl"}
   </td>
   </tr>

   {if $ShowReciprField == 1}
   <tr>
   <td class="label">{if $recpr_required}<span class='req'>*</span>{/if}{l}Reciprocal Link URL{/l}:</td>
   <td class="field">
      <input type="text" name="RECPR_URL" value="{$RECPR_URL|escape|trim}" size="40" maxlength="255" class="text" />
      {validate form="submit_link" id="v_RECPR_URL" message=$smarty.capture.invalid_url}
      {validate form="submit_link" id="v_RECPR_ONLINE" message=$smarty.capture.url_not_online}
      {validate form="submit_link" id="v_RECPR_LINK" message=$smarty.capture.recpr_not_found|replace:'#SITE_URL#':$smarty.const.DEFAULT_RECPR_URL}
      <br />
      <p class="small">{l}To validate the reciprocal link please include the<br />following HTML code in the page at the URL<br />specified above, before submiting this form:{/l}</p>
      <textarea name="RECPR_TEXT" rows="2" readonly="readonly" cols="50" class="text">&lt;a href="{$smarty.const.DEFAULT_RECPR_URL}"&gt;{$smarty.const.DEFAULT_RECPR_TITLE}&lt;/a&gt;</textarea>
   </td>
   </tr>
   {/if}

   {if $remove_link}
   <tr>
   <td class="label">{l}Mark for removal{/l}:</td>
   <td class="field">
      <input type="checkbox" id="MARK_REMOVE" name="MARK_REMOVE" /><span class="small">{l}Use with caution{/l}</span>
   </td>
   </tr>
   {/if}

   {if $smarty.const.VISUAL_CONFIRM}
   <tr>
   <td class="label"><span class='req'>*</span>{l}Enter the code shown{/l}:</td>
   <td class="field">
      <input id="IMAGEHASH" name="IMAGEHASH" type="hidden" value="{$imagehash}" />
      <input id="CAPTCHA" name="CAPTCHA" type="text" value="" size="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" maxlength="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" class="text" />
      {validate form="submit_link" id="v_CAPTCHA" message=$smarty.capture.invalid_code}
      <br />
      <p class="small">{l}This helps prevent automated registrations.{/l}</p>
      <img src="{$smarty.const.DOC_ROOT}/captcha.php?imagehash={$imagehash}" class="captcha" alt="{l}Visual Confirmation Security Code{/l}" title="{l}Visual Confirmation Security Code{/l}" />
   </td>
   </tr>
   {/if}

   <tr>
      <td colspan="2" class="buttons">
         {if !$review_link and !$remove_link}
            <input type="submit" name="submit" value="{l}Continue{/l}" class="btn" />
         {else}
            <input type="submit" name="edit" value="{l}Continue{/l}" class="btn" />
         {/if}
      </td>
  </tr>
</table>
</form>
{/if}

{include file="footer.tpl"}
{/strip}