<?php 
require_once 'init.php'; 
session_start(); 
if (empty($_POST['submit'])) 
{ 
   if (!empty($_SERVER['HTTP_REFERER'])) 
      $_SESSION['return'] = $_SERVER['HTTP_REFERER']; 
   SmartyValidate :: connect($tpl); 
   SmartyValidate :: register_form('contact_form', true); 
   SmartyValidate :: register_criteria('isNotEqual', 'validate_not_equal', 'contact_form'); 
   SmartyValidate :: register_validator('v_name', 'name', 'notEmpty', false, false, false, 'contact_form'); 
   SmartyValidate :: register_validator('v_email', 'email', 'isEmail', false, false, false, 'contact_form'); 
   SmartyValidate :: register_validator('v_reason', 'reason:0', 'isNotEqual', true, false, false,  'contact_form'); 
   SmartyValidate :: register_validator('v_message', 'message', 'notEmpty', false, false, false, 'contact_form'); 
} 
else 
{ 
   SmartyValidate :: connect($tpl); 
   $data = array(); 
   $data['name'] = $_POST['name']; 
   $data['email'] = $_POST['email']; 
   $data['reason'] = $_POST['reason']; 
   $data['message'] = $_POST['message']; 
   if (SmartyValidate :: is_valid($data, 'contact_form')) 
   { 
      require_once 'libs/phpmailer/class.phpmailer.php'; 
      $mail = new PHPMailer(); 
      $mail->PluginDir = 'libs/phpmailer/'; 
      $mail->Mailer = 'mail'; 
      $mail->From = $data['email']; 
      $mail->FromName = $data['name']; 
      $mail->Subject = $data['reason']; 
      $mail->Body = $data['message']; 
      $mail->AddAddress('    ', '    '); 
      if (!$mail->Send()) 
      { 
         $tpl->assign('error', true); 
      } 
      else 
      { 
         $tpl->assign('success', true); 
      } 
      $mail->ClearAddresses(); 
   } 
} 

$path = array (); 
$path[] = array ('ID' => '0', 'TITLE' => _L(SITE_NAME), 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => ''); 
$path[] = array ('ID' => '0', 'TITLE' => _L('Contact Us'), 'TITLE_URL' => '', 'DESCRIPTION' => _L('Contact Us')); 
$tpl->assign($data); 
$tpl->assign('path', $path); 

echo $tpl->fetch('contact.tpl'); 
?>