{capture name="title"} - {l}User Management{/l}{/capture}
{capture assign="in_page_title"}{l}User Management{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}

{strip}
{if $thank_you}
<table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
   <tr>
      <td>
         <h3>{l}Information{/l}</h3>
      </td>
   </tr>
   <tr>
      <td>
         {l}Thank you for registering. Your account has been created. You may now log in with your username and password.{/l}
      </td>
   </tr>
</table>

{elseif $agreement_terms}
<table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
   <tr>
      <td>
         <h3>{l}Registration Agreement Terms{/l}</h3>
      </td>
   </tr>
   <tr>
      <td>
         While the administrators and editors of this link directory will attempt to remove or edit any generally objectionable material as quickly as possible, it is impossible to review every link. Therefore you acknowledge that all links submitted to this link directory express the views and opinions of the author and not the administrators, editors or webmaster (except for posts by these people) and hence will not be held liable.
<br /><br />
         You agree not to post any abusive, obscene, vulgar, slanderous, hateful, threatening, sexually-oriented or any other links and/or material that may violate any applicable laws. Doing so may lead to you being immediately and permanently banned (and your service provider being informed). The IP address of all submitted links is recorded to aid in enforcing these conditions. You agree that the webmaster, administrator and editors of this link directory have the right to remove, edit or move any link at any time should they see fit. As a user you agree to any information you have entered above being stored in a database. While this information will not be disclosed to any third party without your consent the webmaster, administrator and editors cannot be held responsible for any cracking attempt that may lead to the data being compromised.
<br /><br />
         This link directory uses sessions to store information. These do not contain any of the information you have entered above; they serve only to improve your viewing and submit pleasure. The e-mail address is used only for confirming your registration details and password (and for sending new passwords should you forget your current one).
<br /><br />
         By clicking Register below you agree to be bound by these conditions.
      </td>
   </tr>
   <tr>
      <td>
         <a href="{$smarty.const.DOC_ROOT}/profile.php?mode=register&amp;agreed=true" title="{l}I Agree to these terms{/l}">{l}I Agree to these terms{/l}</a>
      </td>
   </tr>
   <tr>
      <td>
         <a href="{$smarty.const.DOC_ROOT}/profile.php?mode=register&amp;agreed=false" title="{l}I Do Not Agree to these terms{/l}">{l}I Do Not Agree to these terms{/l}</a>
      </td>
   </tr>
</table>

{elseif $confirm eq 1}
   {if $password_recovered eq 1}
   <table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
      <tr>
         <td>
            <h3>{l}Information{/l}</h3>
         </td>
      </tr>
      <tr>
         <td>
            {l}You can now login with your new password.{/l}
         </td>
      </tr>
   </table>

   {elseif $password_recovered eq 0}
   <table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
      <tr>
         <td>
            <h3>{l}Information{/l}</h3>
         </td>
      </tr>
      <tr>
         <td class="err">
            {l}An error occured while saving your new password.{/l}
         </td>
      </tr>
   </table>
   {/if}

{elseif $send_password eq 1}
   {if $email_status eq 1 or $wrong_user_details eq 1}
      <table border="0" class="formPage" align="center" style="clear:both; margin-top:3em;">
      <tr>
         <td>
            <h3>{l}Information{/l}</h3>
         </td>
      </tr>
      <tr>
         <td class="{if $email_sent eq 'sent'}msg{else}err{/if}">
            {if $email_sent eq 'sent'}
               {l}Please check your email to confirm your new password request.{/l}
            {elseif $email_sent eq 'error'}
               {l}An error occurred while sending the email.{/l}
               {if $email_error_msg}<br />{$email_error_msg}{/if}
            {elseif $wrong_user_details}
               {l}The details you supplied do not match any registered user.{/l}
            {else}
               {l}Unknown error.{/l}
            {/if}
         </td>
      </tr>
   </table>
   {else}
   <form method="post" action="">
   <table border="0" class="formPage" align="center" width="auto" style="clear:both; margin-top:3em;">
      <tr>
         <td colspan="2">
            <h3>{l}Recover Password{/l}</h3>
         </td>
      </tr>
      <tr>
         <td class="label"><span class='req'>*</span>{l}Login{/l}:</td>
         <td class="smallDesc">
            <input type="text" name="LOGIN" value="{$LOGIN}" size="20" maxlength="{$smarty.const.USER_LOGIN_MAX_LENGTH}" class="text" />
            {validate form="profile" id="v_LOGIN" message=$smarty.capture.field_char_required}
            {validate form="profile" id="v_LOGIN_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.USER_LOGIN_MIN_LENGTH|replace:'#MAX#':$smarty.const.USER_LOGIN_MAX_LENGTH}
         </td>
      </tr>
      <tr>
         <td class="label"><span class='req'>*</span>{l}Email{/l}:</td>
         <td class="smallDesc">
            <input type="text" name="EMAIL" value="{$EMAIL}" size="20" maxlength="255" class="text" />
            {validate form="profile" id="v_EMAIL" message=$smarty.capture.invalid_email}
         </td>
      </tr>
      {if $smarty.const.VISUAL_CONFIRM}
      <tr>
         <td class="label">
            <span class='req'>*</span>{l}Confirmation code{/l}
            <p class="small">{l}This helps prevent automated registrations.{/l}</p>
         </td>
         <td class="smallDesc">
            <input type="text" name="CAPTCHA" value="" size="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" maxlength="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" class="text" autocomplete="off" />
            {validate form="profile" id="v_CAPTCHA" message=$smarty.capture.invalid_code}<br />
            <img src="{$smarty.const.DOC_ROOT}/captcha.php" class="captcha" alt="{l}Visual Confirmation Security Code{/l}" title="{l}Visual Confirmation Security Code{/l}" />
         </td>
      </tr>
      {/if}
      <tr>
         <td>&nbsp;</td>
         <td><input type="submit" name="submit" value="Submit" class="btn" /></td>
      </tr>
   </table>
   </form>
   {/if}

{elseif $user_registration eq 1 or $user_edit eq 1}
<form method="post" action="">
<table border="0" class="formPage" align="center" width="auto" style="clear:both; margin-top:3em;">
   {if $profileUpdate}
   <tr>
      <td class="msg" colspan="2">{l}Profile updated{/l}</td>
   </tr>
   {/if}
   <tr>
      <td colspan="2">
         <h3>{l}Registration Information{/l}</h3>
      </td>
   </tr>
   {if $user_registration eq 1}
   <tr>
      <td class="label"><span class='req'>*</span>{l}Login{/l}:</td>
      <td class="smallDesc">
         <input type="text" name="LOGIN" value="{$LOGIN}" size="20" maxlength="{$smarty.const.USER_LOGIN_MAX_LENGTH}" class="text" />
         {validate form="profile" id="v_LOGIN" message=$smarty.capture.field_char_required}
         {validate form="profile" id="v_LOGIN_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.USER_LOGIN_MIN_LENGTH|replace:'#MAX#':$smarty.const.USER_LOGIN_MAX_LENGTH}
         {validate form="profile" id="v_LOGIN_U" message=$smarty.capture.login_not_unique}
      </td>
   </tr>
   {/if}
   <tr>
      <td class="label"><span class='req'>*</span>{l}Name{/l}:</td>
      <td class="smallDesc">
         <input type="text" name="NAME" value="{$NAME}" size="20" maxlength="{$smarty.const.USER_NAME_MAX_LENGTH}" class="text" />
         {validate form="profile" id="v_NAME" message=$smarty.capture.field_char_required}
         {validate form="profile" id="v_NAME_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.USER_NAME_MIN_LENGTH|replace:'#MAX#':$smarty.const.USER_NAME_MAX_LENGTH}
      </td>
   </tr>
   <tr>
      <td class="label"><span class='req'>*</span>{l}Password{/l}:</td>
      <td class="smallDesc">
         <input type="password" name="PASSWORD" value="" size="20" maxlength="{$smarty.const.USER_PASSWORD_MAX_LENGTH}" class="text" />
         {validate form="profile" id="v_PASSWORD" message=$smarty.capture.field_pass_required}
         {validate form="profile" id="v_PASSWORD_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.USER_PASSWORD_MIN_LENGTH|replace:'#MAX#':$smarty.const.USER_PASSWORD_MAX_LENGTH}
      </td>
   </tr>
   <tr>
      <td class="label"><span class='req'>*</span>{l}Confirm Password{/l}:</td>
      <td class="smallDesc">
         <input type="password" name="PASSWORDC" value="" size="20" maxlength="{$smarty.const.USER_PASSWORD_MAX_LENGTH}" class="text" />
         {validate form="profile" id="v_PASSWORDC" message=$smarty.capture.password_not_match}
      </td>
   </tr>
   <tr>
      <td class="label"><span class='req'>*</span>{l}Language{/l}:</td>
      <td class="smallDesc">
         {html_options options=$languages selected=$LANGUAGE name="LANGUAGE"}
         {validate form="profile" id="v_LANGUAGE" message=$smarty.capture.field_required}
      </td>
   </tr>
   <tr>
      <td class="label"><span class='req'>*</span>{l}Email{/l}:</td>
      <td class="smallDesc">
         <input type="text" name="EMAIL" value="{$EMAIL}" size="20" maxlength="255" class="text" />
         {validate form="profile" id="v_EMAIL" message=$smarty.capture.invalid_email}
         {validate form="profile" id="v_EMAIL_U" message=$smarty.capture.email_not_unique}
      </td>
   </tr>
   {if $smarty.const.VISUAL_CONFIRM}
      <tr>
         <td class="label">
            <span class='req'>*</span>{l}Confirmation code{/l}
            <p class="small">{l}This helps prevent automated registrations.{/l}</p>
         </td>
         <td class="smallDesc">
            <input type="text" name="CAPTCHA" value="" size="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" maxlength="{$smarty.const.CAPTCHA_PHRASE_LENGTH}" class="text" autocomplete="off" />
            {validate form="profile" id="v_CAPTCHA" message=$smarty.capture.invalid_code}<br />
            <img src="{$smarty.const.DOC_ROOT}/captcha.php" class="captcha" alt="{l}Visual Confirmation Security Code{/l}" title="{l}Visual Confirmation Security Code{/l}" />
         </td>
      </tr>
   {/if}
   <tr>
      <td>&nbsp;</td>
      <td><input type="submit" name="submit" value="Register" class="btn" /></td>
   </tr>
</table>
</form>
{/if}

{include file="footer.tpl"}
{/strip}